#pragma once

class CCritSec
{
	CCritSec(const CCritSec &refCritSec);
	CCritSec &operator=(const CCritSec &refCritSec);

	CRITICAL_SECTION m_CritSec;

public:
	CCritSec() { InitializeCriticalSection(&m_CritSec); };
	~CCritSec() { DeleteCriticalSection(&m_CritSec); };

	void Lock() { EnterCriticalSection(&m_CritSec); };
	void Unlock() { LeaveCriticalSection(&m_CritSec); };
};

class CAutoLock
{
	CAutoLock(const CAutoLock &refAutoLock);
	CAutoLock &operator=(const CAutoLock &refAutoLock);

protected:
	CCritSec * m_pLock;

public:
	CAutoLock(CCritSec * plock) {m_pLock = plock; m_pLock->Lock();};
	~CAutoLock() {m_pLock->Unlock();};
};
